/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator.regn.format;

import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.SIMConstants;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.SubsRegRespGenerator;
import com.cra.sim.util.WriteRecord;
import com.cra.sim.validator.BaseValidator;
import com.cra.sim.vo.NomVO;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class NomFormatValidator
extends BaseValidator
implements SIMConstants {
    SubsRegRespGenerator respgen;
    int intColumnNum;
    boolean boolMajMinFlg;
    String strMajMinFlg;
    boolean boolErrCodeFound;
    boolean boolNomAdd;
    boolean boolErrCodeFoundSEF;
    String strNaddrState;
    WriteRecord objWRecord;
    NomVO objNom;
    final String[] strArrCountCodes;
    public static final int SUB_NOMINEE_MINOR_AGE = 18;
    String sectorType;

    public NomFormatValidator(SessionVO sessVO) {
        super(sessVO);
        this.respgen = new SubsRegRespGenerator(this.sessVO);
        this.intColumnNum = 0;
        this.boolMajMinFlg = true;
        this.strMajMinFlg = "";
        this.boolErrCodeFound = false;
        this.boolNomAdd = false;
        this.boolErrCodeFoundSEF = false;
        this.strNaddrState = "";
        this.objWRecord = new WriteRecord();
        this.objNom = new NomVO();
        this.strArrCountCodes = new String[]{"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "CV", "KH", "CM", "CA", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG", "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS", "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW", "XX"};
        this.sectorType = null;
    }

    public NomFormatValidator(SessionVO sessVO, String sectorValue) {
        super(sessVO);
        this.respgen = new SubsRegRespGenerator(this.sessVO);
        this.intColumnNum = 0;
        this.boolMajMinFlg = true;
        this.strMajMinFlg = "";
        this.boolErrCodeFound = false;
        this.boolNomAdd = false;
        this.boolErrCodeFoundSEF = false;
        this.strNaddrState = "";
        this.objWRecord = new WriteRecord();
        this.objNom = new NomVO();
        this.strArrCountCodes = new String[]{"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "CV", "KH", "CM", "CA", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG", "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS", "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW", "XX"};
        this.sectorType = null;
        this.sectorType = sectorValue;
        if ("U".equalsIgnoreCase(this.sectorType)) {
            this.isUnorganizedSector = true;
        }
    }

    public NomVO validateNomFormat(SubsRegConst pcon, boolean isT2, boolean isTts) {
        this.pcon = pcon;
        int intcarotcnt = 0;
        boolean boolRecFlag = true;
        String maritalsts = pcon.getMaritalStatus();
        pcon.setStrErrInRecord("");
        try {
            String errorCode = "";
            int intFieldIndex = 0;
            int intLineStart = 0;
            int intLineEnd = 0;
            if (isT2) {
                System.out.println("ND count for T2 = " + pcon.getIntT2NomRemain());
                pcon.setIntT2NomRemain(pcon.getIntT2NomRemain() - 1);
            } else if (isTts) {
                System.out.println("ND count for Tts = " + pcon.getIntTtsNomRemain());
                pcon.setIntTtsNomRemain(pcon.getIntTtsNomRemain() - 1);
            } else {
                System.out.println("ND count for T1 = " + pcon.getIntNomRemain());
                pcon.setIntNomRemain(pcon.getIntNomRemain() - 1);
            }
            while ((intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^")) >= 0) {
                ++intcarotcnt;
                intLineStart = intLineStart + intLineEnd + 1;
            }
            System.out.println("Minor Flag: " + pcon.getMinortransTypeFlag());
            if (isTts) {
                if (this.isUnorganizedSector) {
                    if (intcarotcnt != 24) {
                        errorCode = "107003";
                        this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, errorCode);
                        this.objNom.setNomErrorFlg(true);
                        return this.objNom;
                    }
                } else if (intcarotcnt != 25) {
                    errorCode = "107003";
                    this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, errorCode);
                    this.objNom.setNomErrorFlg(true);
                    return this.objNom;
                }
            } else if (this.isUnorganizedSector) {
                if (intcarotcnt != 25) {
                    errorCode = isT2 ? "106155" : "101507";
                    this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, errorCode);
                    this.objNom.setNomErrorFlg(true);
                    return this.objNom;
                }
            } else if (intcarotcnt != 24) {
                errorCode = isT2 ? "106155" : "101507";
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, errorCode);
                this.objNom.setNomErrorFlg(true);
                return this.objNom;
            }
            String fieldStr = "";
            boolean boolTempFlag = true;
            String strDOBirth = "";
            intLineEnd = 0;
            intLineStart = 0;
            intFieldIndex = 1;
            block31: while (intLineEnd != -1 && !this.boolErrCodeFound) {
                intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^");
                if (intLineEnd == -1) {
                    fieldStr = pcon.getFileLine().substring(intLineStart).trim();
                } else {
                    fieldStr = pcon.getFileLine().substring(intLineStart, intLineStart + intLineEnd).trim();
                    intLineStart = intLineStart + intLineEnd + 1;
                }
                this.intColumnNum = intFieldIndex;
                strDOBirth = "";
                switch (intFieldIndex) {
                    case 1: {
                        boolTempFlag = this.valLineNumber(fieldStr.trim(), "Line Number", 1);
                        this.objNom.setLineNum(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 2: {
                        boolTempFlag = this.valFileSectType(fieldStr.trim(), "File Section Type", 2);
                        this.objNom.setFileSectType(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 3: {
                        boolean boolTemp = true;
                        boolean errorRepeat = false;
                        if (isTts) {
                            System.out.println("case 3 value = " + fieldStr);
                            String[] sEFErrorCodeArray = new String[4];
                            String[] errorCodeTemp = fieldStr.split("\\,");
                            System.out.println(errorCodeTemp.length);
                            int countOfCommas = fieldStr.length() - fieldStr.replaceAll(",", "").length();
                            if (countOfCommas > 3) {
                                this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "107036");
                                boolRecFlag = false;
                                this.boolErrCodeFound = true;
                            } else {
                                System.arraycopy(errorCodeTemp, 0, sEFErrorCodeArray, 0, errorCodeTemp.length);
                                int i = 0;
                                while (i < sEFErrorCodeArray.length) {
                                    System.out.println("sEFErrorCodeArray[i]::" + sEFErrorCodeArray[i]);
                                    if (sEFErrorCodeArray[i] != null) {
                                        boolTempFlag = this.valErrorFlgCd(sEFErrorCodeArray[i], "Error Flag/Code", 3);
                                    }
                                    System.out.println("boolTempFlag::" + boolTempFlag);
                                    if (!boolTempFlag) {
                                        System.out.println("boolTempFlag1:" + boolTempFlag);
                                        boolRecFlag = false;
                                        this.boolErrCodeFound = true;
                                    }
                                    ++i;
                                }
                                if (errorCodeTemp.length == 1 && "N".equalsIgnoreCase(errorCodeTemp[0])) {
                                    this.objNom.setErrorFlagCode(sEFErrorCodeArray[0]);
                                } else if (errorCodeTemp.length != 1 || sEFErrorCodeArray[0].startsWith("SEF")) {
                                    i = 0;
                                    while (i < sEFErrorCodeArray.length) {
                                        System.out.println("sEFErrorCodeArrayi[" + i + "]::" + sEFErrorCodeArray[i]);
                                        int k = i + 1;
                                        while (k < sEFErrorCodeArray.length - 1) {
                                            System.out.println("sEFErrorCodeArrayk[" + k + "]::" + sEFErrorCodeArray[k]);
                                            System.out.println("sEFErrorCodeArrayk[" + i + "]::" + sEFErrorCodeArray[i]);
                                            if (sEFErrorCodeArray[i] != null && sEFErrorCodeArray[k] != null && sEFErrorCodeArray[i].trim().equalsIgnoreCase(sEFErrorCodeArray[k].trim())) {
                                                errorRepeat = true;
                                                boolRecFlag = false;
                                                this.boolErrCodeFound = true;
                                                System.out.println("errorRepeat::" + errorRepeat);
                                            }
                                            ++k;
                                        }
                                        ++i;
                                    }
                                    System.out.println("errorRepeat::" + errorRepeat);
                                    if (errorRepeat) {
                                        System.out.println("hello");
                                        this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "107037");
                                    } else if (!errorRepeat) {
                                        if (sEFErrorCodeArray[0] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[0])) {
                                            this.objNom.setErrorFlagCode1(sEFErrorCodeArray[0].trim());
                                        }
                                        if (sEFErrorCodeArray[1] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[1])) {
                                            this.objNom.setErrorFlagCode2(sEFErrorCodeArray[1].trim());
                                        }
                                        if (sEFErrorCodeArray[2] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[2])) {
                                            this.objNom.setErrorFlagCode3(sEFErrorCodeArray[2].trim());
                                        }
                                        if (sEFErrorCodeArray[3] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[3])) {
                                            this.objNom.setErrorFlagCode4(sEFErrorCodeArray[3].trim());
                                        }
                                    }
                                    if (fieldStr.length() > 1 && !errorRepeat) {
                                        if (sEFErrorCodeArray[0] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[0])) {
                                            String errorCode1 = sEFErrorCodeArray[0].trim().replace("SEF", "11");
                                            System.out.println("errorCode1--" + errorCode1);
                                            System.out.println(sEFErrorCodeArray[0]);
                                            this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[0].trim(), errorCode1);
                                            this.boolErrCodeFound = true;
                                        }
                                        if (sEFErrorCodeArray[1] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[1])) {
                                            String errorCode1 = sEFErrorCodeArray[1].trim().replace("SEF", "11");
                                            System.out.println("errorCode2--" + errorCode1);
                                            this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[1].trim(), errorCode1);
                                            this.boolErrCodeFound = true;
                                        }
                                        if (sEFErrorCodeArray[2] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[2])) {
                                            String errorCode1 = sEFErrorCodeArray[2].trim().replace("SEF", "11");
                                            System.out.println("errorCode3--" + errorCode1);
                                            this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[2].trim(), errorCode1);
                                            this.boolErrCodeFound = true;
                                        }
                                        if (sEFErrorCodeArray[3] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[3])) {
                                            String errorCode1 = sEFErrorCodeArray[3].trim().replace("SEF", "11");
                                            System.out.println("errorCode4" + errorCode1);
                                            this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[3].trim(), errorCode1);
                                            this.boolErrCodeFound = true;
                                        }
                                    }
                                }
                            }
                        } else {
                            boolTempFlag = this.valErrorFlgCd(fieldStr.trim(), "Error Flag/Code", 3);
                            this.objNom.setErrorFlagCode(fieldStr.trim());
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        } else if (fieldStr.trim().length() == 7) {
                            this.boolErrCodeFound = true;
                            if (isT2) {
                                pcon.setIntT2NomRecNum(pcon.getIntT2NomRecNum() + 1);
                                errorCode = "106156";
                            } else if (isTts) {
                                pcon.setIntTtsNomRecNum(pcon.getIntTtsNomRecNum() + 1);
                                errorCode = "107047";
                            } else {
                                pcon.setIntNomRecNum(pcon.getIntNomRecNum() + 1);
                                errorCode = "103034";
                            }
                            this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr.trim(), errorCode);
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 4: {
                        if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "U".equalsIgnoreCase(pcon.getMaritalStatus())) {
                            boolTempFlag = true;
                            System.out.println("umarried");
                        } else {
                            boolTempFlag = this.valNomRecordNumber(fieldStr.trim(), "Record Number", 4, isT2, isTts);
                            this.objNom.setRecordNumber(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                                System.out.println("ND valNomRecordNumber() error");
                            }
                        }
                        if (isT2) {
                            pcon.setIntT2NomRecNum(Integer.parseInt(fieldStr.trim()));
                        } else if (isTts) {
                            pcon.setIntTtsNomRecNum(Integer.parseInt(fieldStr.trim()));
                        } else {
                            pcon.setIntNomRecNum(Integer.parseInt(fieldStr.trim()));
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 5: {
                        if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "U".equalsIgnoreCase(pcon.getMaritalStatus())) {
                            boolTempFlag = true;
                            System.out.println("umarried");
                        } else {
                            boolTempFlag = this.valNomSrNum(fieldStr.trim(), "Nominee Sr. No.", 5, isT2, isTts);
                            this.objNom.setNomSrno(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 6: {
                        boolTempFlag = pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag()) ? this.valFirstName(fieldStr.trim(), "Guardian First Name", 6) : (pcon.getUPStransTypeFlag() != null && "P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "M".equalsIgnoreCase(maritalsts) ? this.valFirstNameUPS(fieldStr.trim(), "Nominee First Name", 6) : this.valFirstName(fieldStr.trim(), "Nominee First Name", 6));
                        this.objNom.setFName(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 7: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.valLastName(fieldStr.trim(), "Guardian Last Name", 7);
                        } else if (pcon.getUPStransTypeFlag() != null && "P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "M".equalsIgnoreCase(maritalsts)) {
                            boolTempFlag = this.valLastNameUPS(fieldStr.trim(), "Nominee Last Name", 7);
                            System.out.println(String.valueOf(fieldStr) + "case 8 nominee");
                        } else {
                            boolTempFlag = this.valLastName(fieldStr.trim(), "Nominee Last Name", 7);
                        }
                        this.objNom.setLName(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 8: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.valMiddleName(fieldStr.trim(), "Guardian Middle Name", 8);
                        } else if (pcon.getUPStransTypeFlag() != null && "P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "M".equalsIgnoreCase(maritalsts)) {
                            System.out.println(String.valueOf(fieldStr) + "case 8 nominee");
                            boolTempFlag = this.valMiddleNameUPS(fieldStr.trim(), "Nominee Middle Name", 8);
                        } else {
                            boolTempFlag = this.valMiddleName(fieldStr.trim(), "Nominee Middle Name", 8);
                        }
                        this.objNom.setMName(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 9: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            System.out.println("DOB for minor case 9:" + fieldStr + "boolflag: " + boolTempFlag + "minor trans type: " + pcon.getMinortransTypeFlag());
                            boolTempFlag = this.valDobForMinor(fieldStr.trim(), "DOB for Guardian", 9);
                        }
                        System.out.println("case 9:" + fieldStr + "boolflag: " + boolTempFlag);
                        this.objNom.setDOB(fieldStr.trim());
                        this.objNom.setMinor(fieldStr.trim());
                        ++intFieldIndex;
                        break;
                    }
                    case 10: {
                        String gender = pcon.getGender();
                        System.out.println("maritalSts::" + maritalsts);
                        System.out.println("gender::" + gender);
                        boolTempFlag = pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag()) ? this.valRelationForMinFile(fieldStr.trim(), "Guardian Relationship with Minor", 10, maritalsts, gender) : this.valRelation(fieldStr.trim(), "Relationship", 10, maritalsts, gender);
                        this.objNom.setRelationcode(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 11: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            String Relationship = this.objNom.getRelationcode();
                            boolTempFlag = this.valRelationOthrs(fieldStr.trim(), "Relationship-Others", 11, Relationship);
                        }
                        this.objNom.setRelation(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 12: {
                        boolTempFlag = pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag()) ? this.valMajMinFlgForMinorfile(fieldStr.trim(), "Major/Minor Flag", 12) : this.valMajMinFlg(fieldStr.trim(), "Major/Minor Flag", 12);
                        this.objNom.setMinor(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        this.boolMajMinFlg = boolTempFlag;
                        this.strMajMinFlg = fieldStr.trim();
                        strDOBirth = this.objNom.getDOB();
                        if (strDOBirth != null) {
                            boolTempFlag = pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag()) ? this.valDob1(strDOBirth.trim(), "DOB for Guardian", 91, this.strMajMinFlg) : this.valDob1(strDOBirth.trim(), "Nominee Date of Birth", 9, this.strMajMinFlg);
                            this.objNom.setDOB(strDOBirth);
                        }
                        if (boolTempFlag) {
                            boolTempFlag = this.validNomDateOfBirth(strDOBirth.trim(), "Nominee Date of Birth", 9, this.strMajMinFlg);
                        }
                        if (boolTempFlag) continue block31;
                        boolRecFlag = false;
                        this.objNom.setDOB("");
                        break;
                    }
                    case 13: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.isFillerField(fieldStr, 13);
                            this.objNom.setGrdFName(fieldStr);
                        } else {
                            boolTempFlag = this.valGuardFirstName(fieldStr.trim(), "Guardian's First Name", 13);
                            this.objNom.setGrdFName(fieldStr.trim());
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 14: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.isFillerField(fieldStr, 14);
                            this.objNom.setGrdFName(fieldStr);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        if (!this.boolMajMinFlg) continue block31;
                        boolTempFlag = this.valGuardLastName(fieldStr.trim(), "Guardian's Last Name", 14);
                        this.objNom.setGrdLName(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 15: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.isFillerField(fieldStr, 15);
                            this.objNom.setGrdMName(fieldStr);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        if (!this.boolMajMinFlg) continue block31;
                        boolTempFlag = this.valGuardMiddleName(fieldStr.trim(), "Guardian's Middle Name", 15);
                        this.objNom.setGrdMName(fieldStr.trim());
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 16: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.isFillerField(fieldStr, 16);
                            this.objNom.setPercShare(100);
                            System.out.println("perc share: " + this.objNom.getPercShare());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        } else {
                            boolTempFlag = this.valPerShare(fieldStr.trim(), "Percentage Share", 16);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            } else {
                                this.objNom.setPercShare(Integer.parseInt(fieldStr.trim()));
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 17: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag()) || pcon.getUPStransTypeFlag() != null && "P".equalsIgnoreCase(pcon.getUPStransTypeFlag())) {
                            boolTempFlag = this.isFillerField(fieldStr, 17);
                        } else if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag()) || pcon.getUPStransTypeFlag() != null && "P".equalsIgnoreCase(pcon.getUPStransTypeFlag())) {
                            boolTempFlag = this.isFillerField(fieldStr, 17);
                        } else {
                            boolTempFlag = this.valNomInvCond(fieldStr.trim(), "Nominee Invalid condition", 16);
                            this.objNom.setInvalidCond(fieldStr.trim());
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 18: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.validMinorFileGender(fieldStr.trim(), "Gender of Guardian", 18, this.objNom.getRelation());
                            this.objNom.setMinorGrdGender(fieldStr);
                            System.out.println("case 13 if:" + fieldStr + "boolflag: " + boolTempFlag);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        } else {
                            boolTempFlag = this.isFillerField(fieldStr, 18);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 19: {
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.validMinorGrdnPAN(fieldStr.trim(), "Guardian PAN", 19, pcon.getForm60flg(), pcon.getUsperson());
                            this.objNom.setMinorGrdPan(fieldStr);
                        } else {
                            boolTempFlag = this.isFillerField(fieldStr, 19);
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 20: {
                        System.out.println("case 20:" + fieldStr + "boolflag: " + boolTempFlag);
                        if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                            boolTempFlag = this.validMinorGrdnFatherName(fieldStr, "Guardian's Father's Name", 20, pcon.getUsperson());
                            this.objNom.setMinorGrdFName(fieldStr);
                        } else {
                            boolTempFlag = this.isFillerField(fieldStr, 20);
                        }
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 21: {
                        boolTempFlag = this.isFillerField(fieldStr, 21);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 22: {
                        boolTempFlag = this.isFillerField(fieldStr, 22);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 23: {
                        boolTempFlag = this.isFillerField(fieldStr, 23);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 24: {
                        boolTempFlag = this.isFillerField(fieldStr, 24);
                        if (!boolTempFlag) {
                            boolRecFlag = false;
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 25: {
                        String MajminFlg;
                        if (!this.isUnorganizedSector) {
                            if (isTts) {
                                boolTempFlag = this.isFillerField(fieldStr, 25);
                                if (!boolTempFlag) {
                                    boolRecFlag = false;
                                }
                            } else {
                                MajminFlg = this.objNom.getMinor();
                                System.out.println("MajminFlg::" + MajminFlg);
                                boolTempFlag = this.valNomineeage(this.strNaddrState, fieldStr, "Nominee Age", 25, MajminFlg);
                                this.objNom.setNomAge(fieldStr);
                                if (!boolTempFlag) {
                                    boolRecFlag = false;
                                }
                            }
                        } else {
                            boolTempFlag = this.isFillerField(fieldStr, 25);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    case 26: {
                        String MajminFlg;
                        if (!this.isUnorganizedSector) {
                            if (isTts) {
                                MajminFlg = this.objNom.getMinor();
                                System.out.println("MajminFlg::" + MajminFlg);
                                boolTempFlag = this.valNomineeage(this.strNaddrState, fieldStr, "Nominee Age", 25, MajminFlg);
                                this.objNom.setNomAge(fieldStr);
                                if (!boolTempFlag) {
                                    boolRecFlag = false;
                                }
                            } else {
                                boolTempFlag = this.isFillerField(fieldStr, 26);
                                if (!boolTempFlag) {
                                    boolRecFlag = false;
                                }
                            }
                        } else {
                            if (pcon.getMinortransTypeFlag() != null && "M".equalsIgnoreCase(pcon.getMinortransTypeFlag())) {
                                boolTempFlag = this.isFillerField(fieldStr, 26);
                            } else {
                                MajminFlg = this.objNom.getMinor();
                                System.out.println("MajminFlg::" + MajminFlg);
                                boolTempFlag = this.valNomineeage(this.strNaddrState, fieldStr, "Nominee Age", 25, MajminFlg);
                                this.objNom.setNomAge(fieldStr);
                            }
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                        }
                        ++intFieldIndex;
                        break;
                    }
                    default: {
                        boolRecFlag = false;
                    }
                }
            }
            if (SubsRegConst.getUtilityLevel() == 1) {
                if (boolRecFlag) {
                    if (this.addHash(pcon.getFileLine())) {
                        this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                        this.objNom.setNomErrorFlg(false);
                        return this.objNom;
                    }
                    this.objNom.setNomErrorFlg(true);
                    return this.objNom;
                }
                this.objNom.setNomErrorFlg(true);
                return this.objNom;
            }
            this.objNom.setNomErrorFlg(!boolRecFlag);
            return this.objNom;
        }
        catch (Exception e) {
            this.objNom.setNomErrorFlg(true);
            return this.objNom;
        }
    }

    public NomVO validateNomFormatUPS(SubsRegConst pcon, boolean isT2, boolean isTts) {
        this.pcon = pcon;
        int intcarotcnt = 0;
        boolean boolRecFlag = true;
        pcon.setStrErrInRecord("");
        try {
            String errorCode = "";
            int intFieldIndex = 0;
            int intLineStart = 0;
            int intLineEnd = 0;
            if (isT2) {
                System.out.println("ND count for T2 = " + pcon.getIntT2NomRemain());
                pcon.setIntT2NomRemain(pcon.getIntT2NomRemain() - 1);
            } else if (isTts) {
                System.out.println("ND count for Tts = " + pcon.getIntTtsNomRemain());
                pcon.setIntTtsNomRemain(pcon.getIntTtsNomRemain() - 1);
            } else {
                System.out.println("ND count for T1 = " + pcon.getIntNomRemain());
                pcon.setIntNomRemain(pcon.getIntNomRemain() - 1);
            }
            while ((intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^")) >= 0) {
                ++intcarotcnt;
                intLineStart = intLineStart + intLineEnd + 1;
            }
            if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag().trim()) && intcarotcnt != 32) {
                errorCode = isT2 ? "106155" : "101507";
                this.respgen.genHTML(pcon, "Carat Count", "" + intcarotcnt, errorCode);
                this.objNom.setNomErrorFlg(true);
                return this.objNom;
            }
            String fieldStr = "";
            boolean boolTempFlag = true;
            String strDOBirth = "";
            intLineEnd = 0;
            intLineStart = 0;
            intFieldIndex = 1;
            String verType = "";
            verType = intcarotcnt == 32 ? "NEW" : "OLD";
            if (verType.equalsIgnoreCase("NEW")) {
                while (intLineEnd != -1 && !this.boolErrCodeFound) {
                    intLineEnd = pcon.getFileLine().substring(intLineStart).indexOf("^");
                    if (intLineEnd == -1) {
                        fieldStr = pcon.getFileLine().substring(intLineStart).trim();
                    } else {
                        fieldStr = pcon.getFileLine().substring(intLineStart, intLineStart + intLineEnd).trim();
                        intLineStart = intLineStart + intLineEnd + 1;
                    }
                    this.intColumnNum = intFieldIndex;
                    strDOBirth = "";
                    switch (intFieldIndex) {
                        case 1: {
                            boolTempFlag = this.valLineNumber(fieldStr.trim(), "Line Number", 1);
                            this.objNom.setLineNum(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 2: {
                            boolTempFlag = this.valFileSectType(fieldStr.trim(), "File Section Type", 2);
                            this.objNom.setFileSectType(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 3: {
                            boolean boolTemp = true;
                            boolean errorRepeat = false;
                            if (isTts) {
                                System.out.println("case 3 value = " + fieldStr);
                                String[] sEFErrorCodeArray = new String[4];
                                String[] errorCodeTemp = fieldStr.split("\\,");
                                System.out.println(errorCodeTemp.length);
                                int countOfCommas = fieldStr.length() - fieldStr.replaceAll(",", "").length();
                                if (countOfCommas > 3) {
                                    this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "107036");
                                    boolRecFlag = false;
                                    this.boolErrCodeFound = true;
                                } else {
                                    System.arraycopy(errorCodeTemp, 0, sEFErrorCodeArray, 0, errorCodeTemp.length);
                                    int i = 0;
                                    while (i < sEFErrorCodeArray.length) {
                                        System.out.println("sEFErrorCodeArray[i]::" + sEFErrorCodeArray[i]);
                                        if (sEFErrorCodeArray[i] != null) {
                                            boolTempFlag = this.valErrorFlgCd(sEFErrorCodeArray[i], "Error Flag/Code", 3);
                                        }
                                        System.out.println("boolTempFlag::" + boolTempFlag);
                                        if (!boolTempFlag) {
                                            System.out.println("boolTempFlag1:" + boolTempFlag);
                                            boolRecFlag = false;
                                            this.boolErrCodeFound = true;
                                        }
                                        ++i;
                                    }
                                    if (errorCodeTemp.length == 1 && "N".equalsIgnoreCase(errorCodeTemp[0])) {
                                        this.objNom.setErrorFlagCode(sEFErrorCodeArray[0]);
                                    } else if (errorCodeTemp.length != 1 || sEFErrorCodeArray[0].startsWith("SEF")) {
                                        i = 0;
                                        while (i < sEFErrorCodeArray.length) {
                                            System.out.println("sEFErrorCodeArrayi[" + i + "]::" + sEFErrorCodeArray[i]);
                                            int k = i + 1;
                                            while (k < sEFErrorCodeArray.length - 1) {
                                                System.out.println("sEFErrorCodeArrayk[" + k + "]::" + sEFErrorCodeArray[k]);
                                                System.out.println("sEFErrorCodeArrayk[" + i + "]::" + sEFErrorCodeArray[i]);
                                                if (sEFErrorCodeArray[i] != null && sEFErrorCodeArray[k] != null && sEFErrorCodeArray[i].trim().equalsIgnoreCase(sEFErrorCodeArray[k].trim())) {
                                                    errorRepeat = true;
                                                    boolRecFlag = false;
                                                    this.boolErrCodeFound = true;
                                                    System.out.println("errorRepeat::" + errorRepeat);
                                                }
                                                ++k;
                                            }
                                            ++i;
                                        }
                                        System.out.println("errorRepeat::" + errorRepeat);
                                        if (errorRepeat) {
                                            System.out.println("hello");
                                            this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr, "107037");
                                        } else if (!errorRepeat) {
                                            if (sEFErrorCodeArray[0] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[0])) {
                                                this.objNom.setErrorFlagCode1(sEFErrorCodeArray[0].trim());
                                            }
                                            if (sEFErrorCodeArray[1] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[1])) {
                                                this.objNom.setErrorFlagCode2(sEFErrorCodeArray[1].trim());
                                            }
                                            if (sEFErrorCodeArray[2] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[2])) {
                                                this.objNom.setErrorFlagCode3(sEFErrorCodeArray[2].trim());
                                            }
                                            if (sEFErrorCodeArray[3] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[3])) {
                                                this.objNom.setErrorFlagCode4(sEFErrorCodeArray[3].trim());
                                            }
                                        }
                                        if (fieldStr.length() > 1 && !errorRepeat) {
                                            if (sEFErrorCodeArray[0] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[0])) {
                                                String errorCode1 = sEFErrorCodeArray[0].trim().replace("SEF", "11");
                                                System.out.println("errorCode1--" + errorCode1);
                                                System.out.println(sEFErrorCodeArray[0]);
                                                this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[0].trim(), errorCode1);
                                                this.boolErrCodeFound = true;
                                            }
                                            if (sEFErrorCodeArray[1] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[1])) {
                                                String errorCode1 = sEFErrorCodeArray[1].trim().replace("SEF", "11");
                                                System.out.println("errorCode2--" + errorCode1);
                                                this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[1].trim(), errorCode1);
                                                this.boolErrCodeFound = true;
                                            }
                                            if (sEFErrorCodeArray[2] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[2])) {
                                                String errorCode1 = sEFErrorCodeArray[2].trim().replace("SEF", "11");
                                                System.out.println("errorCode3--" + errorCode1);
                                                this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[2].trim(), errorCode1);
                                                this.boolErrCodeFound = true;
                                            }
                                            if (sEFErrorCodeArray[3] != null && !"".equalsIgnoreCase(sEFErrorCodeArray[3])) {
                                                String errorCode1 = sEFErrorCodeArray[3].trim().replace("SEF", "11");
                                                System.out.println("errorCode4" + errorCode1);
                                                this.respgen.genHTML(pcon, "Error Flag/Code", sEFErrorCodeArray[3].trim(), errorCode1);
                                                this.boolErrCodeFound = true;
                                            }
                                        }
                                    }
                                }
                            } else {
                                boolTempFlag = this.valErrorFlgCd(fieldStr.trim(), "Error Flag/Code", 3);
                                this.objNom.setErrorFlagCode(fieldStr.trim());
                            }
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            } else if ("SEF0199".equalsIgnoreCase(fieldStr) && !isT2 && !isTts) {
                                this.boolErrCodeFound = false;
                                this.boolErrCodeFoundSEF = true;
                            } else if (fieldStr.trim().length() == 7) {
                                this.boolErrCodeFound = true;
                                if (isT2) {
                                    pcon.setIntT2NomRecNum(pcon.getIntT2NomRecNum() + 1);
                                    errorCode = "106156";
                                } else if (isTts) {
                                    pcon.setIntTtsNomRecNum(pcon.getIntTtsNomRecNum() + 1);
                                    errorCode = "107047";
                                } else {
                                    pcon.setIntNomRecNum(pcon.getIntNomRecNum() + 1);
                                    errorCode = "103034";
                                }
                                this.respgen.genHTML(pcon, "Error Flag/Code", fieldStr.trim(), errorCode);
                            }
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 4: {
                            if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "U".equalsIgnoreCase(pcon.getMaritalStatus())) {
                                boolTempFlag = true;
                            } else {
                                boolTempFlag = this.valNomRecordNumber(fieldStr.trim(), "Record Number", 4, isT2, isTts);
                                this.objNom.setRecordNumber(fieldStr.trim());
                                if (!boolTempFlag) {
                                    boolRecFlag = false;
                                    System.out.println("ND valNomRecordNumber() error");
                                }
                            }
                            if (isT2) {
                                pcon.setIntT2NomRecNum(Integer.parseInt(fieldStr.trim()));
                            } else if (isTts) {
                                pcon.setIntTtsNomRecNum(Integer.parseInt(fieldStr.trim()));
                            } else {
                                pcon.setIntNomRecNum(Integer.parseInt(fieldStr.trim()));
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 5: {
                            if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "U".equalsIgnoreCase(pcon.getMaritalStatus())) {
                                boolTempFlag = true;
                            } else {
                                boolTempFlag = this.valNomSrNum(fieldStr.trim(), "Nominee Sr. No.", 5, isT2, isTts);
                                this.objNom.setNomSrno(fieldStr.trim());
                                if (!boolTempFlag) {
                                    boolRecFlag = false;
                                }
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 6: {
                            if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "M".equalsIgnoreCase(pcon.getMaritalStatus())) {
                                boolTempFlag = this.valFirstNameUPS(fieldStr.trim(), "Legally Wedded Spouse First Name", 6);
                            }
                            this.objNom.setFName(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 7: {
                            if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "M".equalsIgnoreCase(pcon.getMaritalStatus())) {
                                boolTempFlag = this.valLastNameUPS(fieldStr.trim(), "Legally Wedded Spouse Last Name", 7);
                            }
                            this.objNom.setLName(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 8: {
                            if ("P".equalsIgnoreCase(pcon.getUPStransTypeFlag()) && "M".equalsIgnoreCase(pcon.getMaritalStatus())) {
                                boolTempFlag = this.valMiddleNameUPS(fieldStr.trim(), "Legally Wedded Spouse Middle Name", 8);
                            }
                            this.objNom.setMName(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 9: {
                            boolTempFlag = this.valDob1(fieldStr.trim(), "Legally Wedded Spouse Date of Birth", 9, "");
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            this.objNom.setDOB(fieldStr.trim());
                            this.objNom.setMinor(fieldStr.trim());
                            ++intFieldIndex;
                            break;
                        }
                        case 10: {
                            String maritalsts = pcon.getMaritalStatus();
                            String gender = pcon.getGender();
                            String EnpsFlag = pcon.getEnpsFlag();
                            System.out.println("maritalSts::" + maritalsts);
                            System.out.println("gender::" + gender);
                            boolTempFlag = this.valRelation(fieldStr.trim(), "Relationship", 10, maritalsts, gender);
                            this.objNom.setRelcode(fieldStr.trim());
                            this.objNom.setRelation(fieldStr.trim());
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 11: {
                            boolTempFlag = this.isFillerField(fieldStr, 11);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 12: {
                            boolTempFlag = this.isFillerField(fieldStr, 12);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 13: {
                            boolTempFlag = this.isFillerField(fieldStr, 13);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 14: {
                            boolTempFlag = this.isFillerField(fieldStr, 14);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 15: {
                            boolTempFlag = this.isFillerField(fieldStr, 15);
                            this.objNom.setGrdMName(fieldStr);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 16: {
                            boolTempFlag = this.valPerShare(fieldStr, "Percentage Share", 16);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            } else {
                                this.objNom.setPercShare(Integer.parseInt(fieldStr.trim()));
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 17: {
                            boolTempFlag = this.isFillerField(fieldStr, 17);
                            System.out.println("case 17:" + fieldStr + "boolflag: " + boolTempFlag);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 17:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 18: {
                            System.out.println("case 18 else:" + fieldStr + "boolflag: " + boolTempFlag);
                            boolTempFlag = this.isFillerField(fieldStr, 18);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 18:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 19: {
                            boolTempFlag = this.isFillerField(fieldStr, 19);
                            System.out.println("case 19:" + fieldStr + "boolflag: " + boolTempFlag);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 19:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 20: {
                            System.out.println("case 20:" + fieldStr + "boolflag: " + boolTempFlag);
                            boolTempFlag = this.isFillerField(fieldStr, 20);
                            System.out.println("case 20:" + fieldStr + "boolflag: " + boolTempFlag);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 20:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 21: {
                            boolTempFlag = this.isFillerField(fieldStr, 21);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 21:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 22: {
                            boolTempFlag = this.isFillerField(fieldStr, 22);
                            System.out.println("case 22:" + fieldStr + "boolTempFlag: " + boolTempFlag);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 22:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 23: {
                            boolTempFlag = this.isFillerField(fieldStr, 23);
                            System.out.println("case 23:" + fieldStr + "boolTempFlag: " + boolTempFlag);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 23:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 24: {
                            boolTempFlag = this.isFillerField(fieldStr, 24);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 24:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 25: {
                            boolTempFlag = this.isFillerField(fieldStr, 25);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            System.out.println("case 25:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            ++intFieldIndex;
                            break;
                        }
                        case 26: {
                            boolTempFlag = this.isFillerField(fieldStr, 26);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            System.out.println("case 26:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            break;
                        }
                        case 27: {
                            System.out.println("case 27:" + fieldStr + "EnpsFlag: " + pcon.getEnpsFlag() + "boolRecFlag: " + boolRecFlag);
                            boolTempFlag = this.isFillerField(fieldStr, 27);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            System.out.println("case 27:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            break;
                        }
                        case 28: {
                            boolTempFlag = this.isFillerField(fieldStr, 28);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            System.out.println("case 26:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            break;
                        }
                        case 29: {
                            boolTempFlag = this.isFillerField(fieldStr, 29);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            System.out.println("case 29:" + fieldStr + "boolflag: " + boolTempFlag + "boolRecFlag: " + boolRecFlag);
                            break;
                        }
                        case 30: {
                            String genderUPS = pcon.getGender();
                            System.out.println("gender ups " + genderUPS);
                            boolTempFlag = this.valGenderUPS(fieldStr, "Legally Wedded Spouse Gender", 30, genderUPS);
                            this.objNom.setSpousegender(fieldStr);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 31: {
                            boolTempFlag = this.isFillerField(fieldStr, 31);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 32: {
                            boolTempFlag = this.isFillerField(fieldStr, 32);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        case 33: {
                            boolTempFlag = this.isFillerField(fieldStr, 33);
                            if (!boolTempFlag) {
                                boolRecFlag = false;
                            }
                            ++intFieldIndex;
                            break;
                        }
                        default: {
                            boolRecFlag = false;
                        }
                    }
                }
                if (SubsRegConst.getUtilityLevel() == 1) {
                    if (boolRecFlag) {
                        if (this.addHash(pcon.getFileLine())) {
                            this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                            this.objNom.setNomErrorFlg(false);
                            return this.objNom;
                        }
                        this.objNom.setNomErrorFlg(true);
                        return this.objNom;
                    }
                    this.objNom.setNomErrorFlg(true);
                    return this.objNom;
                }
                this.objNom.setNomErrorFlg(!boolRecFlag);
                return this.objNom;
            }
        }
        catch (Exception e) {
            this.objNom.setNomErrorFlg(true);
            return this.objNom;
        }
        return this.objNom;
    }

    public boolean valFileSectType(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            if (!fieldStr.equals("ND")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103021");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valErrorFlgCd(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr.trim(), 7, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (fieldStr.length() != 1 && fieldStr.length() != 7) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103033");
            } else if (fieldStr.length() == 7) {
                if (!fieldStr.substring(0, 3).equals("SEF") || !this.isNumber(fieldStr.substring(3, 7))) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103035");
                    boolTemp = false;
                } else {
                    boolean valid = this.respgen.checkValidErrorCode(fieldStr);
                    if (!valid) {
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103035");
                        boolTemp = false;
                    }
                }
            } else if (fieldStr.length() == 1 && !fieldStr.trim().equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103035");
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNomRecordNumber(String fieldStr, String strColumnName, int intColumnNum, boolean isT2, boolean isTts) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            boolTemp = this.valFieldBasics(fieldStr.trim(), 2, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) == 0) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (isT2) {
                if (Integer.parseInt(fieldStr) != this.pcon.getIntT2NomRecNum() + 1) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                    return boolTemp;
                }
            } else if (isTts) {
                if (Integer.parseInt(fieldStr) != this.pcon.getIntTtsNomRecNum() + 1) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                    return boolTemp;
                }
            } else if (Integer.parseInt(fieldStr) != this.pcon.getIntNomRecNum() + 1) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
            if (fieldStr.length() < 2) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                return boolTemp;
            }
            if (isT2) {
                if (Integer.parseInt(fieldStr) > this.pcon.getIntT2TotNom()) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    return boolTemp;
                }
            } else if (isTts) {
                if (Integer.parseInt(fieldStr) != this.pcon.getIntTtsNomRecNum() + 1) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    return boolTemp;
                }
            } else if (Integer.parseInt(fieldStr) > this.pcon.getIntTotNom()) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNomSrNum(String fieldStr, String strColumnName, int intColumnNum, boolean isT2, boolean isTts) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            boolTemp = this.valFieldBasics(fieldStr.trim(), 2, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) == 0) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
            if (isT2) {
                if (Integer.parseInt(fieldStr) != this.pcon.getIntT2NomRecNum()) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
            } else if (isTts) {
                if (Integer.parseInt(fieldStr) != this.pcon.getIntTtsNomRecNum()) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
            } else if (Integer.parseInt(fieldStr) != this.pcon.getIntNomRecNum()) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                return boolTemp;
            }
            if (fieldStr.length() < 2) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                return boolTemp;
            }
            if (isT2) {
                if (Integer.parseInt(fieldStr) > this.pcon.getIntT2TotNom()) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    return boolTemp;
                }
            } else if (isTts) {
                if (Integer.parseInt(fieldStr) != this.pcon.getIntTtsNomRecNum()) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    return boolTemp;
                }
            } else if (Integer.parseInt(fieldStr) > this.pcon.getIntTotNom()) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valRelation(String fieldStr, String strColName, int intColumnNum, String maritalsts, String gender) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 2, SubsRegConst.getMandatoryValue(), strColName, intColumnNum);
            if (this.isUnorganizedSector) {
                if ("U".equalsIgnoreCase(maritalsts)) {
                    if (!("01".equalsIgnoreCase(fieldStr) || "02".equalsIgnoreCase(fieldStr) || "99".equalsIgnoreCase(fieldStr))) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if ("M".equalsIgnoreCase(maritalsts) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_MARRIED, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if ("M".equalsIgnoreCase(maritalsts) && ("F".equalsIgnoreCase(gender) || "T".equalsIgnoreCase(gender))) {
                    if (!this.isListConstainsValue(VALID_VALUES_FT_MARRIED, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if (("W".equalsIgnoreCase(maritalsts) || "D".equalsIgnoreCase(maritalsts)) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_DIV_WID, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if (("W".equalsIgnoreCase(maritalsts) || "D".equalsIgnoreCase(maritalsts)) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_DIV_WID, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if (("W".equalsIgnoreCase(maritalsts) || "D".equalsIgnoreCase(maritalsts)) && ("F".equalsIgnoreCase(gender) || "T".equalsIgnoreCase(gender))) {
                    if (!this.isListConstainsValue(VALID_VALUES_FT_DIV_WID, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if ("O".equalsIgnoreCase(maritalsts) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_OTHR, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if ("O".equalsIgnoreCase(maritalsts) && ("F".equalsIgnoreCase(gender) || "T".equalsIgnoreCase(gender)) && !this.isListConstainsValue(VALID_VALUES_FT_OTHR, fieldStr)) {
                    this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                    boolTemp = false;
                }
            } else if (!"P".equalsIgnoreCase(this.pcon.getUPStransTypeFlag())) {
                if ("U".equalsIgnoreCase(maritalsts)) {
                    if (!("01".equalsIgnoreCase(fieldStr) || "02".equalsIgnoreCase(fieldStr) || "99".equalsIgnoreCase(fieldStr))) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if ("M".equalsIgnoreCase(maritalsts) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_MARRIED, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if ("M".equalsIgnoreCase(maritalsts) && ("F".equalsIgnoreCase(gender) || "T".equalsIgnoreCase(gender))) {
                    if (!this.isListConstainsValue(VALID_VALUES_FT_MARRIED, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if (("W".equalsIgnoreCase(maritalsts) || "D".equalsIgnoreCase(maritalsts)) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_DIV_WID, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if (("W".equalsIgnoreCase(maritalsts) || "D".equalsIgnoreCase(maritalsts)) && "M".equalsIgnoreCase(gender)) {
                    if (!this.isListConstainsValue(VALID_VALUES_M_DIV_WID, fieldStr)) {
                        this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                        boolTemp = false;
                    }
                } else if (("W".equalsIgnoreCase(maritalsts) || "D".equalsIgnoreCase(maritalsts)) && ("F".equalsIgnoreCase(gender) || "T".equalsIgnoreCase(gender)) && !this.isListConstainsValue(VALID_VALUES_FT_DIV_WID, fieldStr)) {
                    this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                    boolTemp = false;
                }
            } else if ("M".equalsIgnoreCase(maritalsts) && this.pcon.getUPStransTypeFlag() != null && "P".equalsIgnoreCase(this.pcon.getUPStransTypeFlag()) && !"03".equalsIgnoreCase(fieldStr)) {
                System.out.println("In case 10 ND");
                this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103103");
                boolTemp = false;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valRelationForMinFile(String fieldStr, String strColName, int intColumnNum, String maritalsts, String gender) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColName, intColumnNum + 1);
            if (!("F".equalsIgnoreCase(fieldStr) || "M".equalsIgnoreCase(fieldStr) || "L".equalsIgnoreCase(fieldStr))) {
                this.respgen.genHTML(this.pcon, this.strColumnName, fieldStr, "103104");
                boolTemp = false;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valGuardFirstName(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        if (this.boolMajMinFlg) {
            if (!"P".equalsIgnoreCase(this.pcon.getUPStransTypeFlag())) {
                if (this.strMajMinFlg.equals("Y")) {
                    boolTemp = this.valFirstName(fieldStr.trim(), strColumnName, intColumnNum);
                } else if (!fieldStr.trim().equals("") && !fieldStr.trim().equals("NULL")) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103136");
                    boolTemp = false;
                }
            }
        } else {
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103135");
            boolTemp = false;
        }
        return boolTemp;
    }

    public boolean valGuardMiddleName(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        if (this.boolMajMinFlg) {
            if (this.strMajMinFlg.equals("Y")) {
                boolTemp = this.valMiddleName(fieldStr.trim(), strColumnName, intColumnNum);
            } else if (!fieldStr.trim().equals("") && !fieldStr.trim().equals("NULL")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103156");
                boolTemp = false;
            }
        } else {
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103155");
            boolTemp = false;
        }
        return boolTemp;
    }

    public boolean valGuardLastName(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        if (this.boolMajMinFlg) {
            if (this.strMajMinFlg.equals("Y")) {
                boolTemp = this.valLastName(fieldStr.trim(), strColumnName, intColumnNum);
            } else if (!fieldStr.trim().equals("") && !fieldStr.trim().equals("NULL")) {
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103146");
                boolTemp = false;
            }
        } else {
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103145");
            boolTemp = false;
        }
        return boolTemp;
    }

    public boolean valPerShare(String fieldStr, String strColumnName, int ColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 3, SubsRegConst.getMandatoryValue(), strColumnName, this.intColumnNum);
            if (!this.isNumber(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103163");
                return boolTemp;
            }
            if (Integer.parseInt(fieldStr) <= 0) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103164");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMajMinFlg(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (!fieldStr.equals("Y") && !fieldStr.equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103123");
                return boolTemp;
            }
            if ("p".equalsIgnoreCase(this.pcon.getUPStransTypeFlag()) && !fieldStr.equals("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103124");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMajMinFlgForMinorfile(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 1, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (!fieldStr.equalsIgnoreCase("N")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103126");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNomInvCond(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 50, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    boolean validMinorFileGender(String gaurdianGender, String strColumnName, int ColumnNum, String grdnRelation) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(gaurdianGender, 50, SubsRegConst.getMandatoryValue(), strColumnName, this.intColumnNum);
            if (!(gaurdianGender.equalsIgnoreCase("F") || gaurdianGender.equalsIgnoreCase("M") || gaurdianGender.equalsIgnoreCase("T"))) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, gaurdianGender, "103183");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean validMinorGrdnPAN(String strPAN, String strColumnName, int intColumnCode, String form60flag, String USPersonFlg) {
        boolean boolInvStructFlag;
        String strErrCode;
        block16: {
            boolean boolTemp = true;
            strErrCode = String.valueOf(this.getErrorCode(intColumnCode)) + 1;
            try {
                boolTemp = this.valFieldBasics(strPAN.trim(), 10, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
                System.out.println("case 19:" + strPAN + "USPersonFlg: " + USPersonFlg + "form60flag: " + form60flag);
                if ("".equalsIgnoreCase(strPAN)) {
                    System.out.println("Inside valPAN");
                    if ("Y".equalsIgnoreCase(USPersonFlg)) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "3");
                    }
                    if ("N".equalsIgnoreCase(form60flag)) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "3");
                    }
                }
                if (!"".equalsIgnoreCase(strPAN) && strPAN.length() < 10) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "2");
                    return boolTemp;
                }
                boolInvStructFlag = false;
                if (boolTemp) {
                    if (strPAN != null && !"".equalsIgnoreCase(strPAN.trim())) {
                        int i = 0;
                        while (i < strPAN.length()) {
                            char intTemp = strPAN.charAt(i);
                            if (i < 5 || i == 9) {
                                if (intTemp < 'A' || intTemp > '[') {
                                    boolInvStructFlag = true;
                                }
                            } else if (intTemp < '0' || intTemp > '9') {
                                boolInvStructFlag = true;
                            }
                            ++i;
                        }
                        if (strPAN.charAt(3) != 'P') {
                            boolInvStructFlag = true;
                        }
                    }
                    break block16;
                }
                return false;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        if (boolInvStructFlag) {
            this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "4");
            return false;
        }
        return true;
    }

    public boolean validMinorGrdnFatherName(String strFirstName, String strColumnName, int intColumnCode, String USPersonFlg) {
        boolean boolTemp = true;
        boolean cnt = false;
        String strErrCode = String.valueOf(this.getErrorCode(intColumnCode)) + 1;
        try {
            System.out.println("case 20 in method start:" + strFirstName + "USPersonFlg: " + USPersonFlg);
            boolTemp = this.valFieldBasics(strFirstName, 90, SubsRegConst.getOptionalValue(), strColumnName, intColumnCode);
            System.out.println("case 20:" + strFirstName + "USPersonFlg: " + USPersonFlg + "boolTemp: " + boolTemp);
            if ("".equalsIgnoreCase(strFirstName)) {
                System.out.println("Inside valPAN");
                if ("Y".equalsIgnoreCase(USPersonFlg)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                }
            }
            System.out.println("case 20:" + strFirstName + "boolTemp: " + boolTemp);
            return boolTemp;
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
    }

    @Override
    public String getErrorForm() {
        return "103";
    }

    boolean validNomDateOfBirth(String dateOfBirth, String strColumnName, int ColumnNum, String minorFlag) {
        boolean boolTemp = true;
        Date curDate = new Date();
        SimpleDateFormat dformat = new SimpleDateFormat("MMddyyyy");
        Calendar cal = Calendar.getInstance();
        Date nomdob = null;
        try {
            if ("Y".equalsIgnoreCase(minorFlag) && !dateOfBirth.equals("")) {
                nomdob = dformat.parse(dateOfBirth);
                cal.setTime(nomdob);
                cal.add(1, 18);
                if (curDate.compareTo(cal.getTime()) > 0) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, dateOfBirth, "103095");
                    return boolTemp;
                }
            }
            if ("N".equalsIgnoreCase(minorFlag) && !dateOfBirth.equals("")) {
                nomdob = dformat.parse(dateOfBirth);
                System.out.println("DOB**********" + nomdob);
                cal.setTime(nomdob);
                cal.add(1, 18);
                if (curDate.compareTo(cal.getTime()) <= 0) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, dateOfBirth, "103096");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
        }
        return boolTemp;
    }

    boolean valStateCountrymap(String strColumnName, String strStateCode, String strCountryCode) {
        boolean boolTemp = true;
        if (strCountryCode != null && !"".equalsIgnoreCase(strCountryCode)) {
            if (strCountryCode.equalsIgnoreCase("IN") && strStateCode.equals("99")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, String.valueOf(strStateCode) + "/" + strCountryCode, "102316");
                return boolTemp;
            }
            if (!strCountryCode.equalsIgnoreCase("IN") && !strStateCode.equals("99")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, String.valueOf(strStateCode) + "/" + strCountryCode, "102316");
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean valAddress1Nom(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 40, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress2Nom(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 40, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress3Nom(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 40, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress4Nom(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 40, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valIsNomOCI(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        try {
            boolTemp = "99".equalsIgnoreCase(this.objNom.getAddressState()) && !"IN".equalsIgnoreCase(this.objNom.getAddressCountry()) ? this.valFieldBasics(fieldStr, 30, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum) : this.isFillerField(fieldStr, 24);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valFirstNameNom(String strFirstName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        int cnt = 0;
        try {
            boolTemp = this.valFieldBasics(strFirstName.trim(), 30, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (strFirstName.toUpperCase().charAt(0) != '\'' && (strFirstName.toUpperCase().charAt(0) < 'A' || strFirstName.toUpperCase().charAt(0) > 'Z')) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            cnt = 1;
            while (cnt < strFirstName.length()) {
                if (strFirstName.charAt(cnt) != ' ' && strFirstName.charAt(cnt) != '&' && strFirstName.charAt(cnt) != '\'' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '(' && strFirstName.charAt(cnt) != ')' && strFirstName.charAt(cnt) != ',' && strFirstName.charAt(cnt) != '-' && strFirstName.charAt(cnt) != '.' && strFirstName.charAt(cnt) != '/' && strFirstName.charAt(cnt) != '\\' && (strFirstName.toUpperCase().charAt(cnt) < 'A' || strFirstName.toUpperCase().charAt(cnt) > 'Z')) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
                ++cnt;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valStateNom(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        this.strStateCode = fieldStr;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 2, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            System.out.println("boolTemp: " + boolTemp);
            int stateCode = 0;
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                    System.out.println("boolTemp1: " + boolTemp);
                    return boolTemp;
                }
                if (fieldStr.length() < 2) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                    System.out.println("boolTemp2: " + boolTemp);
                    return boolTemp;
                }
                if (this.isNumber(fieldStr)) {
                    stateCode = Integer.parseInt(fieldStr);
                }
                if ((stateCode <= 0 || stateCode > 37) && stateCode != 99 && stateCode != 88) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    System.out.println("boolTemp3: " + boolTemp);
                    return boolTemp;
                }
                if ("08".equalsIgnoreCase(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    System.out.println("boolTemp3: " + boolTemp);
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valCountryNom(String fieldStr, String strColumnName, int intColumnNum, boolean isT2, boolean isTts) {
        boolean boolTemp = true;
        boolean boolCountCodeFound = false;
        String strErrCode = this.getErrorCode(intColumnNum);
        this.strCountCode = fieldStr;
        try {
            boolTemp = this.valFieldBasics(fieldStr, 2, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (fieldStr.length() < 2) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                }
                int i = 0;
                while (i < this.strArrCountCodes.length) {
                    if (fieldStr.equals(this.strArrCountCodes[i])) {
                        boolCountCodeFound = true;
                    }
                    ++i;
                }
                if (!boolCountCodeFound) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valNomineeage(String strState, String fieldStr, String strColumnName, int intColumnNum, String MajminFlg) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            boolTemp = this.valFieldBasics(fieldStr, 3, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                    return boolTemp;
                }
                if ("Y".equalsIgnoreCase(MajminFlg) && this.isNumber(fieldStr) && Long.parseLong(fieldStr) >= 18L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                    return boolTemp;
                }
                if ("N".equalsIgnoreCase(MajminFlg) && this.isNumber(fieldStr) && Long.parseLong(fieldStr) < 18L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valDobForMinor(String strDob, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        boolTemp = this.valFieldBasics(strDob.trim(), 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum);
        return boolTemp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean valDob1(String strDob, String strColumnName, int intColumnNum, String strMajMinFlg) {
        boolean boolTemp = true;
        Date curDate = new Date();
        SimpleDateFormat dformat = new SimpleDateFormat("MMddyyyy");
        Date dtDOB = null;
        String strErrCode = this.getErrorCode(intColumnNum);
        if ("p".equalsIgnoreCase(this.pcon.getUPStransTypeFlag())) {
            if (strDob == null || "".equalsIgnoreCase(strDob)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "9");
                return boolTemp;
            }
            try {
                if (!boolTemp) return boolTemp;
                if (strDob == null) return boolTemp;
                if (strDob.equalsIgnoreCase("")) return boolTemp;
                try {
                    dtDOB = dformat.parse(strDob);
                }
                catch (Exception e) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "11");
                    return boolTemp;
                }
                if (strDob.length() < 8) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "10");
                    return boolTemp;
                }
                if (!this.isDate(strDob)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "11");
                    return boolTemp;
                }
                if (!curDate.before(dtDOB)) return boolTemp;
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "12");
                return boolTemp;
            }
            catch (Exception e) {
                return false;
            }
        }
        boolTemp = "Y".equalsIgnoreCase(strMajMinFlg) ? this.valFieldBasics(strDob.trim(), 8, SubsRegConst.getMandatoryValue(), strColumnName, intColumnNum) : this.valFieldBasics(strDob.trim(), 8, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
        try {
            if (!boolTemp) return boolTemp;
            if (strDob == null) return boolTemp;
            if (strDob.equalsIgnoreCase("")) return boolTemp;
            try {
                dtDOB = dformat.parse(strDob);
            }
            catch (Exception e) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (strDob.length() < 8) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if (!this.isDate(strDob)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "3");
                return boolTemp;
            }
            if (!curDate.before(dtDOB)) return boolTemp;
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strDob, String.valueOf(strErrCode) + "4");
            return boolTemp;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean valPinNom(String strState, String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (!"IN".equalsIgnoreCase(this.objNom.getAddressCountry())) {
                boolTemp = this.valFieldBasics(fieldStr, 10, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
            } else {
                boolTemp = this.valFieldBasics(fieldStr, 6, SubsRegConst.getOptionalValue(), strColumnName, intColumnNum);
                if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                    if (fieldStr.length() != 6) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
                        return boolTemp;
                    }
                    if (fieldStr.startsWith("0")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) != 99 && fieldStr.equals("999999")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) == 99 && !fieldStr.equals("999999")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) != 88 && fieldStr.equals("888888")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                        return boolTemp;
                    }
                    if (Integer.parseInt("0" + strState) == 88 && !fieldStr.equals("888888")) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                        return boolTemp;
                    }
                    if (!this.isNumber(fieldStr)) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                        return boolTemp;
                    }
                    if (this.isNumber(fieldStr) && Long.parseLong(fieldStr) == 0L) {
                        boolTemp = false;
                        this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "10");
                        return boolTemp;
                    }
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valRelationOthrs(String fieldStr, String strColName, int intColumnNum, String Relationship) {
        boolean boolTemp = true;
        try {
            boolTemp = Relationship != null && !"".equalsIgnoreCase(Relationship) && "99".equalsIgnoreCase(Relationship) ? this.valFieldBasics(fieldStr, 30, SubsRegConst.getMandatoryValue(), strColName, intColumnNum) : this.valFieldBasics(fieldStr, 30, SubsRegConst.getOptionalValue(), strColName, intColumnNum);
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean validUPSSpousenPAN(String strPAN, String strColumnName, int intColumnCode) {
        boolean boolInvStructFlag;
        String strErrCode;
        block15: {
            boolean boolTemp = true;
            strErrCode = this.getErrorCode(intColumnCode);
            boolInvStructFlag = false;
            try {
                if (strPAN == null || "".equalsIgnoreCase(strPAN)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "6");
                    return boolTemp;
                }
                if (strPAN.length() > 10) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "7");
                    return boolTemp;
                }
                if (!"".equalsIgnoreCase(strPAN) && strPAN.length() < 10) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "7");
                    return boolTemp;
                }
                if (boolTemp) {
                    if (strPAN != null && !"".equalsIgnoreCase(strPAN.trim())) {
                        int i = 0;
                        while (i < strPAN.length()) {
                            char intTemp = strPAN.charAt(i);
                            if (i < 5 || i == 9) {
                                if (intTemp < 'A' || intTemp > '[') {
                                    boolInvStructFlag = true;
                                }
                            } else if (intTemp < '0' || intTemp > '9') {
                                boolInvStructFlag = true;
                            }
                            ++i;
                        }
                        if (strPAN.charAt(3) != 'P') {
                            boolInvStructFlag = true;
                        }
                    }
                    break block15;
                }
                return false;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        if (boolInvStructFlag) {
            this.respgen.genHTML(this.pcon, strColumnName, strPAN, String.valueOf(strErrCode) + "8");
            return false;
        }
        return true;
    }

    public boolean valFirstNameUPS(String strFirstName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        String spouseFirstName = this.pcon.getSpouseFirstNameValue();
        if (strFirstName == null || "".equalsIgnoreCase(strFirstName)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "6");
            return boolTemp;
        }
        if (strFirstName.length() > 30) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "7");
            return boolTemp;
        }
        if (boolTemp && !strFirstName.equalsIgnoreCase(spouseFirstName)) {
            this.respgen.genHTML(this.pcon, strColumnName, strFirstName, String.valueOf(strErrCode) + "5");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valLastNameUPS(String strLastName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        String spouseLastName = this.pcon.getSpouseLastNameValue();
        if (strLastName != null && !"".equalsIgnoreCase(strLastName)) {
            if (strLastName.length() > 30) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if (boolTemp && !strLastName.equalsIgnoreCase(spouseLastName)) {
                this.respgen.genHTML(this.pcon, strColumnName, strLastName, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean valMiddleNameUPS(String strMiddleName, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        String spouseMiddleName = this.pcon.getSpouseMiddleNameValue();
        if (strMiddleName != null && !"".equalsIgnoreCase(strMiddleName)) {
            if (strMiddleName.length() > 30) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if (boolTemp && !strMiddleName.equalsIgnoreCase(spouseMiddleName)) {
                this.respgen.genHTML(this.pcon, strColumnName, strMiddleName, String.valueOf(strErrCode) + "5");
                return boolTemp;
            }
        }
        return boolTemp;
    }

    public boolean valAddress1UPS(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (fieldStr == null || "".equalsIgnoreCase(fieldStr)) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "6");
                return boolTemp;
            }
            if (fieldStr.length() > 40) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddress2UPS(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (fieldStr.length() > 40) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddressCity(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (fieldStr.length() > 40) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valAddressDistrict(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (fieldStr.length() > 40) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valStateUPS(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        this.strStateCode = fieldStr;
        try {
            if (fieldStr.length() > 2) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                return boolTemp;
            }
            System.out.println("boolTemp: " + boolTemp);
            int stateCode = 0;
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                    System.out.println("boolTemp1: " + boolTemp);
                    return boolTemp;
                }
                if (fieldStr.length() < 2) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "7");
                    System.out.println("boolTemp2: " + boolTemp);
                    return boolTemp;
                }
                if (this.isNumber(fieldStr)) {
                    stateCode = Integer.parseInt(fieldStr);
                }
                if ((stateCode <= 0 || stateCode > 37) && stateCode != 99 && stateCode != 88) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                    System.out.println("boolTemp3: " + boolTemp);
                    return boolTemp;
                }
                if ("08".equalsIgnoreCase(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                    System.out.println("boolTemp3: " + boolTemp);
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valCountrySpouse(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        boolean boolCountCodeFound = false;
        String strErrCode = this.getErrorCode(intColumnNum);
        this.strCountCode = fieldStr;
        try {
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (fieldStr.length() > 2) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1032312");
                    return boolTemp;
                }
                int i = 0;
                while (i < this.strArrCountCodes.length) {
                    if (fieldStr.equals(this.strArrCountCodes[i])) {
                        boolCountCodeFound = true;
                    }
                    ++i;
                }
                if (!boolCountCodeFound) {
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1032313");
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valPinUPS(String strState, String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (boolTemp && fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
                if (fieldStr.length() != 6) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
                    return boolTemp;
                }
                if (fieldStr.startsWith("0")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1032411");
                    return boolTemp;
                }
                if (Integer.parseInt("0" + strState) != 99 && fieldStr.equals("999999")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "103247");
                    return boolTemp;
                }
                if (Integer.parseInt("0" + strState) == 99 && !fieldStr.equals("999999")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                    return boolTemp;
                }
                if (Integer.parseInt("0" + strState) != 88 && fieldStr.equals("888888")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1032410");
                    return boolTemp;
                }
                if (Integer.parseInt("0" + strState) == 88 && !fieldStr.equals("888888")) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1032410");
                    return boolTemp;
                }
                if (!this.isNumber(fieldStr)) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "9");
                    return boolTemp;
                }
                if (this.isNumber(fieldStr) && Long.parseLong(fieldStr) == 0L) {
                    boolTemp = false;
                    this.respgen.genHTML(this.pcon, strColumnName, fieldStr, "1032414");
                    return boolTemp;
                }
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valSpouseAadhar(String fieldStr, String strColumnName, int intColumnNum) {
        boolean boolTemp = true;
        String strErrCode = this.getErrorCode(intColumnNum);
        try {
            if (fieldStr.length() > 4) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "8");
                return boolTemp;
            }
        }
        catch (Exception e) {
            boolTemp = false;
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valMobNumSpouse(String fieldStr, String strColumnName, int intColumnCode) {
        int length;
        String mobNo;
        String strErrCode;
        boolean boolTemp;
        block7: {
            boolTemp = true;
            strErrCode = this.getErrorCode(intColumnCode);
            try {
                mobNo = "";
                if (fieldStr == null || "".equalsIgnoreCase(fieldStr) || fieldStr.length() <= 14 && fieldStr.length() >= 10) break block7;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return false;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && fieldStr.startsWith("+")) {
            mobNo = fieldStr.substring(1, fieldStr.length());
        }
        if (!this.isNumber(mobNo) && !this.boolErrCodeFoundSEF) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        if (!mobNo.equals("") && Long.parseLong(mobNo) == 0L) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "4");
            return boolTemp;
        }
        if (fieldStr != null && !"".equalsIgnoreCase(fieldStr) && ((length = fieldStr.length()) == 10 && fieldStr.startsWith("0") || length == 11 && !fieldStr.startsWith("0") || length == 12 && !fieldStr.startsWith("91") || length == 13 && !fieldStr.startsWith("+91"))) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "5");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valEmailIdSpouse(String fieldStr, String strColumnName, int intColumnCode) {
        String strErrCode;
        boolean boolTemp;
        block4: {
            boolTemp = true;
            strErrCode = this.getErrorCode(intColumnCode);
            try {
                if (fieldStr == null || "".equalsIgnoreCase(fieldStr) || fieldStr.length() <= 80) break block4;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return false;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        if (!fieldStr.equals("") && !this.isEmailId(fieldStr)) {
            boolTemp = false;
            this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "3");
            return boolTemp;
        }
        return boolTemp;
    }

    public boolean valGenderUPS(String fieldStr, String strColumnName, int intColumnCode, String Subgender) {
        String strErrCode;
        boolean boolTemp;
        block7: {
            boolTemp = true;
            strErrCode = this.getErrorCode(intColumnCode);
            try {
                if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) break block7;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "1");
                return false;
            }
            catch (Exception e) {
                boolTemp = false;
                return boolTemp;
            }
        }
        if (fieldStr != null && !"".equalsIgnoreCase(fieldStr)) {
            if ("M".equalsIgnoreCase(Subgender) && !fieldStr.equals("F") && !fieldStr.equals("T")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if ("F".equalsIgnoreCase(Subgender) && !fieldStr.equals("M") && !fieldStr.equals("T")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
            if ("T".equalsIgnoreCase(Subgender) && !fieldStr.equals("M") && !fieldStr.equals("F")) {
                boolTemp = false;
                this.respgen.genHTML(this.pcon, strColumnName, fieldStr, String.valueOf(strErrCode) + "2");
                return boolTemp;
            }
        }
        return boolTemp;
    }
}

